<?php


namespace Module\Wenku\Core;


use ModStart\Core\Dao\ModelUtil;
use Module\Vendor\Provider\SiteUrl\AbstractSiteUrlBiz;
use Module\Vendor\Provider\SiteUrl\SiteUrlProvider;
use Module\Wenku\Type\WenkuDocStatus;
use Module\Wenku\Util\UrlUtil;

class WenkuDocSiteUrlBiz extends AbstractSiteUrlBiz
{
    const NAME = 'wenkuDoc';

    public function name()
    {
        return self::NAME;
    }

    public function title()
    {
        return '文库文档';
    }

    public function urlBuildBatch($nextId, $param = [])
    {
        $records = [];
        $batchRet = ModelUtil::batch('wenku_doc', $nextId, 1000, [
            'status' => WenkuDocStatus::VERIFY_PASS,
        ]);
        $finish = empty($batchRet['records']);
        foreach ($batchRet['records'] as $record) {
            $records[] = [
                'url' => UrlUtil::doc($record),
                'updateTime' => $record['updated_at'],
            ];
        }
        return [
            'finish' => $finish,
            'records' => $records,
            'nextId' => $batchRet['nextId'],
        ];
    }

}

